program ClinicalCaseRegistries;

{%ToDo 'ClinicalCaseRegistries.todo'}

uses
  ShareMem,
  Forms,
  Classes,
  SysUtils,
  WinHelpViewer,
  fROR_Main in 'fROR_Main.pas' {MainForm},
  uROR_CommonUtils in 'uROR_CommonUtils.pas',
  fROR_VistARegistries in 'fROR_VistARegistries.pas' {FormSelectRegistry},
  fROR_RegistryInfo in 'fROR_RegistryInfo.pas' {FormRegistryInfo},
  fROR_UserList in 'fROR_UserList.pas' {FormUserList},
  fROR_AboutDlg in 'fROR_AboutDlg.pas' {FormAboutDlg},
  uROR_CRC in 'uROR_CRC.pas',
  fROR_CDCList in 'fROR_CDCList.pas' {FormCDC},
  fROR_Options in 'fROR_Options.pas' {FormOptions},
  uROR_Reports in 'uROR_Reports.pas',
  uROR_Common in 'uROR_Common.pas',
  fROR_XMLEngine in 'fROR_XMLEngine.pas' {XMLEngine},
  fROR_DateTimeSelector in 'fROR_DateTimeSelector.pas' {frmDTSelector},
  uROR_ICRPatientData in 'uROR_ICRPatientData.pas',
  fROR_ICRPatientEdit in 'fROR_ICRPatientEdit.pas' {frmICRPatientEdit},
  fROR_VUSelector in 'fROR_VUSelector.pas' {dlgVUSelector},
  fGMV_TimeOutManager in 'fGMV_TimeOutManager.pas' {frmGMV_TimeOutManager},
  uROR_NamespaceHandler in 'uROR_NamespaceHandler.pas',
  uROR_MultiStream in 'uROR_MultiStream.pas',
  uROR_DateTime in 'uROR_DateTime.pas',
  fROR_PatientEdit in 'fROR_PatientEdit.pas' {FormPatientEdit},
  fROR_HEPCPatientEdit in 'fROR_HEPCPatientEdit.pas' {FormHEPCPatientEdit},
  uROR_HEPCPatientData in 'uROR_HEPCPatientData.pas',
  uROR_User in 'uROR_User.pas',
  uROR_PatientData in 'uROR_PatientData.pas',
  uROR_PatientDataLists in 'uROR_PatientDataLists.pas',
  uROR_Errors in 'uROR_Errors.pas',
  uROR_Strings in 'uROR_Strings.pas',
  fROR_MDIChild in 'fROR_MDIChild.pas' {FormMDIChild},
  fROR_GenericRegistry in 'fROR_GenericRegistry.pas' {FormGenericRegistry},
  fROR_ICR in 'fROR_ICR.pas' {FormICR},
  fROR_HEPC in 'fROR_HEPC.pas' {FormHEPC},
  fROR_UserDefined in 'fROR_UserDefined.pas' {FormUserDefined},
  fROR_XMLReport in 'fROR_XMLReport.pas' {FormXMLReport},
  uROR_Utilities,
  fROR_ReportParams in 'fROR_ReportParams.pas' {FrameReportParameters: TFrame},
  fROR_ReportSelector in 'fROR_ReportSelector.pas' {FormReportSelector},
  fROR_RPLoadSave in 'fROR_RPLoadSave.pas' {FormRPLoadSave},
  fROR_SiteParams in 'fROR_SiteParams.pas' {FormSiteParameters},
  uROR_UDPatientData in 'uROR_UDPatientData.pas',
  uROR_Logs in 'uROR_Logs.pas',
  oleacc in 'oleacc.pas',
  MSAAConstants in 'MSAAConstants.pas',
  uROR_XML in 'uROR_XML.pas',
  uROR_CCRCmdLine in 'uROR_CCRCmdLine.pas',
  uROR_TemplateFormatFix in 'uROR_TemplateFormatFix.pas',
  fROR_Info in 'fROR_Info.pas' {frmInfo},
  uROR_HelpMgr in 'uROR_HelpMgr.pas',
  fROR_508PatientEdLocal in 'fROR_508PatientEdLocal.pas' {Form508PatientEdLocal};

{$R *.RES}

var
  NormalRun: Boolean = False;

begin
  Application.Initialize;
  Application.Title := 'CCR v1.5.24';
  Application.CreateForm(TFormMain, FormMain);
  Application.CreateForm(TForm508PatientEdLocal, Form508PatientEdLocal);
  try
    if CmdLineParams.Help then
      CmdLineParams.ShowHelp
    else if FormMain.Connect then
      begin
        Application.CreateForm(TdlgVUSelector, dlgVUSelector);
        NormalRun := True;
      end;
  except
    on E: Exception do
      Application.ShowException(E);
  end;

  //--- Run the application
  if NormalRun then
    begin
      TOurNSHandler.Register;
      InitTimeout(nil);
      {$IFDEF AANTEST}
      UpdateTimeoutInterval(30000);
      {$ELSE}
      if Assigned(CCRUser) then
        UpdateTimeoutInterval(CCRUser.Timeout);
      {$ENDIF}
      try
        Application.Run;
      finally
        ShutDownTimeOut;
        TOurNSHandler.Unregister;
      end;
    end
  else
    begin
      Application.ShowMainForm := False;
      Application.Terminate;
      Application.Run;
    end;
end.
